import { View, Text, Pressable } from "react-native";
import React, {useEffect} from "react";
import { settingStyle } from "./SettingStyle";
import RightIcon from "../../../assets/svgs/product details/rightIcon.svg"
import BackNavigation from "../../Utilities/CustomHeader/BackNavigation";
import { useDispatch, useSelector } from "react-redux";
import useLangTranslation from "../../../hooks/useLangTranslation";
import { languages } from "../../../src/language/languages";
import CustomSVG from "../../../src/components/CustomSVG/CustomSVG";
import gapStyle from "../../Utilities/CommonStyles/gap.style";
import { useIsFocused } from "@react-navigation/native";
import { resetState } from "../../../redux/slices/user/deleteUser/deleteUser";

const Setting = (props) => {
    const { trans } = useLangTranslation();
    const { lng } = useSelector((state) => state.languageReducer);
    const language = languages.find((item) => item.langCode === lng);

    const isFocused = useIsFocused();
    const dispatch = useDispatch();

    useEffect(() => {
        if(isFocused) dispatch(resetState());
    }, [isFocused])

    return (
        <View style={settingStyle.settingRoot}>
            <BackNavigation
                navigationProps={props.navigation}
                routeName={trans("settings")}
                capitalize={false}
            />
            <View style={settingStyle.hrLine} />
            <View style={settingStyle.container}>
                <Pressable
                    android_ripple={{ color: "gray" }}
                    onPress={() => props.navigation.navigate("select language")}
                    style={settingStyle.itemBox}
                >
                    <View>
                        <Text style={settingStyle.title}>{trans("Language")}</Text>
                        <Text style={settingStyle.subTitle}>{language?.title}</Text>
                    </View>
                    <CustomSVG svgIcon={RightIcon} isRtl={1} />
                </Pressable>
                <Pressable
                    android_ripple={{ color: "gray" }}
                    onPress={() => props.navigation.navigate("delete account")}
                    style={[settingStyle.itemBox, gapStyle.mt15]}
                >
                    <View>
                        <Text style={settingStyle.title}>{trans("Delete Account")}</Text>
                        <Text style={settingStyle.subTitle}>{trans("You can't get back your account anymore.")}</Text>
                    </View>
                    <CustomSVG svgIcon={RightIcon} isRtl={1} />
                </Pressable>
            </View>
        </View>
    );
};

export default Setting;
